<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Gestión Ambiental - Responsabilidad Social Universitaria UNSM">
    <meta name="theme-color" content="#359444">
    <title>Gestión Ambiental - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../../../imagenes/escudo unsm.png" sizes="48x48">
    <!-- Stylesheets -->
    <link rel="stylesheet" href="../../../../css/style.css">
    <link rel="stylesheet" href="css/styleGesAmb.css?v=1.1">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer"><img src="../../../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36"></a>
                <a href="https://www.instagram.com/unsmperu" target="_blank" rel="noopener noreferrer"><img src="../../../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36"></a>
                <a href="https://youtube.com/@unsmperu" target="_blank" rel="noopener noreferrer"><img src="../../../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36"></a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer"><img src="../../../../imagenes/redes/logo x.png" alt="X" width="36" height="36"></a>
                <a href="https://www.tiktok.com/@campus.unsm" target="_blank" rel="noopener noreferrer"><img src="../../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36"></a>
            </nav>
            <div class="contact-info">
                <span><img src="../../../../imagenes/logo telefono.png" alt="Teléfono" class="contact-icon" width="18" height="18"><span>(+51) (042) 48 0159</span></span>
                <span><img src="../../../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18"><span>informes@unsm.edu.pe</span></span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../../../" aria-label="Ir a la página principal de UNSM">
                    <img src="../../../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="70">
                </a>
            </div>

            <!-- Botón Hamburguesa para móvil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menú de navegación" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegación principal">
                <div class="mobile-nav-logo">
                    <img src="../../../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="../../../../#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menú Nosotros">
                            <li><a href="../../../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../../../nosotros/mision/indexMision.php">Nuestra Misión y Visión</a></li>
                            <li><a href="../../../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../../../nosotros/calendarioAcade/indexCale.php">Calendario Académico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="../../../../#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menú Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../../../../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../../../../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Académico</a></li>
                                <li><a href="../../../../oficinas/vicerrectorado de investigacion/indexViceRecAca.php">Vicerrectorado de Investigación</a></li>
                                <li><a href="../../../../oficinas/secretaria general/indexSecreGene.php">Secretaría General</a></li>
                                <li><a href="../../../../oficinas/planeamiento y presupuesto/indexPlanea.php">Planeamiento y Presupuesto</a></li>
                                <li><a href="../../../../oficinas/seguridad y salud ocupacional/indexSeguri.php">Seguridad y Salud Ocupacional</a></li>
                                <li><a href="../../../../oficinas/comunicacion y imagen institucional/indexImagen.php">Comunicación e Imagen Institucional</a></li>
                                <li><a href="../../../../oficinas/Cooperacion y Relaciones Internacionales/indexCoopera.php">Cooperación y Relaciones Internacionales</a></li>
                                <li><a href="../../../../oficinas/Organo de Control Institucional/indexOrgaConIns.php">Órgano de Control Institucional</a></li>
                                <li><a href="../../../../oficinas/Ejecutora de Inversiones/indexEjec.php">Ejecutora de Inversiones</a></li>
                                <li><a href="../../../../oficinas/Asesoria Juridica/indexAseJuri.php">Asesoría Jurídica</a></li>
                                <li><a href="../../../../oficinas/Grados y Titulos/indexGrados.php">Grados y Títulos</a></li>
                            </div>
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Académicas</li>
                                <li><a href="../../OFICINA DE ADMISION/indexOfiAdmin.php">Oficina de Admisión</a></li>
                                <li><a href="../../ASUNTOS ACADEMICOS/indexAsunAca.php">Asuntos Académicos</a></li>
                                <li><a href="../../Seguimiento al Egresado e Insercion Laboral/indexSegui.php">Seguimiento al Egresado e Inserción Laboral</a></li>
                                <li><a href="../../TECNOLOGIAS DE LA INFORMACION/indexOTI.php">Tecnologías de la Información</a></li>
                                <li><a href="../../INCUBADORA DE EMPRESAS/indexIncu.php">Incubadora de Empresas</a></li>
                                <li><a href="../../FONDO EDITORIAL/indexFondo.php">Fondo Editorial</a></li>
                                <li><a href="../../COMITE ELECTORAL UNIVERSITARIO/indexComite.php">Comité Electoral Universitario</a></li>
                                <li><a href="../../INNOVACION Y TRANSFERENCIA TECNOLOGICA/indexInno.php">Innovación y Transferencia Tecnológica</a></li>
                                <li><a href="../../PRODUCCION DE BIENES Y SERVICIOS/indexProdu.php">Producción de Bienes y Servicios</a></li>
                                <li><a href="../indexRespon.php">Responsabilidad Social Universitaria</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../../../oficinas/Academicos/OFICINA DE ADMISION/indexOfiAdmin.php">ADMISIÓN</a></li>
                    <li><a href="../../../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menú Facultades">
                            <li class="has-submenu">
                                <a href="#">Ciencias Agrarias</a>
                                <ul class="submenu-carreras">
                                    <li><a href="#">Agronomía</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#">Ciencias de la Salud</a>
                                <ul class="submenu-carreras">
                                    <li><a href="#">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#">Ingeniería Civil y Arquitectura</a>
                                <ul class="submenu-carreras">
                                    <li><a href="#">Arquitectura</a></li>
                                    <li><a href="#">Ingeniería Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#">Ciencias Económicas</a>
                                <ul class="submenu-carreras">
                                    <li><a href="#">Administración</a></li>
                                    <li><a href="#">Contabilidad</a></li>
                                    <li><a href="#">Economía</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#">Educación y Humanidades</a>
                                <ul class="submenu-carreras">
                                    <li><a href="#">Educación Inicial</a></li>
                                    <li><a href="#">Educación Primaria</a></li>
                                    <li><a href="#">Idiomas</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../../../#posgrado">POSGRADO</a></li>
                    <li class="dropdown">
                        <a href="../../../../#transparencia" aria-haspopup="true" aria-expanded="false">TRANSPARENCIA</a>
                        <ul class="dropdown-menu" aria-label="Menú Transparencia">
                            <li><a href="#">Licenciamiento</a></li>
                            <li><a href="#">Institucional Ley 30220</a></li>
                            <li><a href="#">Estándar Ley 27806</a></li>
                        </ul>
                    </li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer">
                        <img src="../../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer">
                        <img src="../../../../imagenes/logo gobPe.png" alt="Gobierno del Perú" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer">
                    <img src="../../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer">
                    <img src="../../../../imagenes/logo gobPe.png" alt="Gobierno del Perú" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Hero Slider -->
    <section class="hero-slider">
        <div class="slider-container">
            <div class="slide active">
                <div class="slide-bg bg-1"></div>
            </div>
            <div class="slide">
                <div class="slide-bg bg-2"></div>
            </div>
            <div class="slide">
                <div class="slide-bg bg-3"></div>
            </div>
        </div>
        <button class="slider-btn prev" aria-label="Anterior">&#10094;</button>
        <button class="slider-btn next" aria-label="Siguiente">&#10095;</button>
        <div class="slider-dots">
            <span class="dot active" data-slide="0"></span>
            <span class="dot" data-slide="1"></span>
            <span class="dot" data-slide="2"></span>
        </div>
    </section>

    <!-- Notas Informativas -->
    <section class="section-notas">
        <div class="section-header"><h2>Notas Informativas</h2></div>
        <div class="container">
            <div class="notas-grid">
                <article class="nota-card">
                    <div class="nota-image placeholder-img"><span class="nota-badge">Leer más</span></div>
                    <div class="nota-content">
                        <span class="nota-date">internacionalización, Notas UNSM</span>
                        <h3>Experiencia de Proyectos de Investigación con Enfoque Ambiental</h3>
                    </div>
                </article>
                <article class="nota-card">
                    <div class="nota-image placeholder-img"><span class="nota-badge">Leer más</span></div>
                    <div class="nota-content">
                        <span class="nota-date">internacionalización</span>
                        <h3>Día Internacional de la Diversidad Biológica</h3>
                    </div>
                </article>
                <article class="nota-card">
                    <div class="nota-image placeholder-img"><span class="nota-badge verde">Leer más</span></div>
                    <div class="nota-content">
                        <span class="nota-date">UNSM | Gestión Ambiental</span>
                        <h3>Conviértete en un líder ambiental</h3>
                    </div>
                </article>
                <article class="nota-card">
                    <div class="nota-image placeholder-img"><span class="nota-badge">Leer más</span></div>
                    <div class="nota-content">
                        <span class="nota-date">Gestión Ambiental</span>
                        <h3>Calendario Ambiental Peruano 2025</h3>
                    </div>
                </article>
                <article class="nota-card">
                    <div class="nota-image placeholder-img"><span class="nota-badge">Leer más</span></div>
                    <div class="nota-content">
                        <span class="nota-date">Gestión Ambiental</span>
                        <h3>Invitación a clausura del Diplomado en Seguridad Ciudadana</h3>
                    </div>
                </article>
                <article class="nota-card">
                    <div class="nota-image placeholder-img"><span class="nota-badge verde">Leer más</span></div>
                    <div class="nota-content">
                        <span class="nota-date">internacionalización</span>
                        <h3>Reforestación del Parque La Planicie</h3>
                    </div>
                </article>
            </div>
            <a href="#" class="btn-ver-mas">Ver más</a>
        </div>
    </section>

    <!-- Actividades Desarrolladas -->
    <section class="section-actividades">
        <div class="section-header"><h2>Actividades desarrolladas</h2></div>
        <div class="container">
            <div class="actividades-grid">
                <article class="actividad-card">
                    <div class="actividad-image placeholder-img"></div>
                    <div class="actividad-content">
                        <h3>Únete a la Limpieza de la Laguna Andiviela en el Distrito de Morales</h3>
                        <p>La Dirección de Responsabilidad Social Universitaria y el Comité Ambiental, te invitan a participar...</p>
                    </div>
                </article>
                <article class="actividad-card">
                    <div class="actividad-image placeholder-img"></div>
                    <div class="actividad-content">
                        <h3>2° Feria ENADESS 2024 - Cada Residuo en su lugar</h3>
                        <p>Este 28 de septiembre, se llevó a cabo con gran éxito el 2do día de la Jornada Integral...</p>
                    </div>
                </article>
                <article class="actividad-card">
                    <div class="actividad-image placeholder-img"></div>
                    <div class="actividad-content">
                        <h3>Día del Árbol en el Perú</h3>
                        <p>La Universidad Nacional de San Martín desarrolló esta importante actividad ambiental...</p>
                    </div>
                </article>
            </div>
            <a href="#" class="btn-ver-mas">Ver más</a>
        </div>
    </section>

    <!-- Fondos Concursables -->
    <section class="section-fondos">
        <div class="section-header"><h2>Fondos Concursables - DRSU</h2></div>
        <div class="container">
            <div class="fondos-grid">
                <article class="fondo-card">
                    <div class="fondo-image"><img src="../../../../imagenes/logo UNSM.png" alt="UNSM" class="fondo-logo"></div>
                    <div class="fondo-buttons">
                        <a href="#" class="btn-fondo rojo">Regulación</a>
                        <a href="#" class="btn-fondo verde">Reporte Nivel 1</a>
                    </div>
                    <div class="fondo-content">
                        <span class="fondo-date">01 septiembre, 2024</span>
                        <h3>Mesa Participativa 2024</h3>
                    </div>
                </article>
                <article class="fondo-card">
                    <div class="fondo-image"><img src="../../../../imagenes/logo UNSM.png" alt="UNSM" class="fondo-logo"></div>
                    <div class="fondo-buttons">
                        <a href="#" class="btn-fondo rojo">Regulación</a>
                        <a href="#" class="btn-fondo verde">Reporte Nivel 1</a>
                    </div>
                    <div class="fondo-content">
                        <span class="fondo-date">1 julio, 2024</span>
                        <h3>Concurso de Fondo Concursables de Responsabilidad Social y Ambiental</h3>
                    </div>
                </article>
            </div>
        </div>
    </section>

    <!-- Objetivos de Desarrollo Sostenible -->
    <section class="section-ods">
        <div class="section-header"><h2>Objetivos de Desarrollo Sostenible</h2></div>
        <div class="container">
            <div class="ods-grid">
                <div class="ods-item ods-1"><span>1</span><p>FIN DE LA POBREZA</p></div>
                <div class="ods-item ods-2"><span>2</span><p>HAMBRE CERO</p></div>
                <div class="ods-item ods-3"><span>3</span><p>SALUD Y BIENESTAR</p></div>
                <div class="ods-item ods-4"><span>4</span><p>EDUCACIÓN DE CALIDAD</p></div>
                <div class="ods-item ods-5"><span>5</span><p>IGUALDAD DE GÉNERO</p></div>
                <div class="ods-item ods-6"><span>6</span><p>AGUA LIMPIA</p></div>
                <div class="ods-item ods-7"><span>7</span><p>ENERGÍA ASEQUIBLE</p></div>
                <div class="ods-item ods-8"><span>8</span><p>TRABAJO DECENTE</p></div>
                <div class="ods-item ods-9"><span>9</span><p>INDUSTRIA E INNOVACIÓN</p></div>
                <div class="ods-item ods-10"><span>10</span><p>REDUCCIÓN DESIGUALDADES</p></div>
                <div class="ods-item ods-11"><span>11</span><p>CIUDADES SOSTENIBLES</p></div>
                <div class="ods-item ods-12"><span>12</span><p>PRODUCCIÓN RESPONSABLE</p></div>
                <div class="ods-item ods-13"><span>13</span><p>ACCIÓN POR EL CLIMA</p></div>
                <div class="ods-item ods-14"><span>14</span><p>VIDA SUBMARINA</p></div>
                <div class="ods-item ods-15"><span>15</span><p>VIDA ECOSISTEMAS</p></div>
                <div class="ods-item ods-16"><span>16</span><p>PAZ E INSTITUCIONES</p></div>
                <div class="ods-item ods-17"><span>17</span><p>ALIANZAS</p></div>
                <div class="ods-item ods-logo"><span>ODS</span><p>OBJETIVOS DE DESARROLLO SOSTENIBLE</p></div>
            </div>
        </div>
    </section>

    <!-- Miembros y Documentos -->
    <section class="section-miembros">
        <div class="section-header"><h2>Miembros y Documentos de la Gestión</h2></div>
        <div class="container">
            <div class="miembros-grid">
                <article class="miembro-card">
                    <div class="miembro-image coordinador placeholder-avatar"></div>
                    <div class="miembro-info">
                        <h3>Ing. M.Sc. Wanhin Orlando Aguilar Herrera</h3>
                        <p>Coordinador General</p>
                    </div>
                </article>
                <article class="miembro-card">
                    <div class="miembro-image presidente placeholder-avatar"></div>
                    <div class="miembro-info">
                        <h3>Ing. M. Sc. Elías Torres Flores</h3>
                        <p>Presidente de la comisión</p>
                    </div>
                </article>
                <article class="miembro-card">
                    <div class="miembro-image miembro placeholder-avatar"></div>
                    <div class="miembro-info">
                        <h3>Mtr. Juana Paola Ruiz Salva</h3>
                        <p>Miembro de la Comisión</p>
                    </div>
                </article>
                <article class="miembro-card">
                    <div class="miembro-image miembro placeholder-avatar"></div>
                    <div class="miembro-info">
                        <h3>Dr. Edwin Augusto Hernández Torres</h3>
                        <p>Miembro de la Comisión</p>
                    </div>
                </article>
                <article class="miembro-card">
                    <div class="miembro-image miembro placeholder-avatar"></div>
                    <div class="miembro-info">
                        <h3>Ing. M. Sc. Percy Martínez Dávila</h3>
                        <p>Miembro de la Comisión</p>
                    </div>
                </article>
            </div>

        </div>
    </section>

    <!-- Documentos de la Gestión -->
    <section class="section-documentos">
        <div class="container">
            <div class="documentos-grid">
                <div class="documentos-lista">
                    <h4>Resoluciones de Asignación de la Comisión</h4>
                    <ul>
                        <li><a href="#">Política Ambiental</a></li>
                        <li><a href="#">Plan de Gestión Ambiental</a></li>
                        <li><a href="#">Estatutos</a></li>
                        <li><a href="#">Actas de Reuniones</a></li>
                    </ul>
                </div>
                <div class="documentos-lista">
                    <h4>Resoluciones</h4>
                    <ul>
                        <li><a href="#">Resolución Rectoral N° 296-2024/UNSM/R</a></li>
                        <li><a href="#">Resolución Rectoral N° 184-2024/UNSM/R</a></li>
                        <li><a href="#">Resolución Rectoral N° 373-2023/UNSM/R</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../../../imagenes/escudo unsm.png" alt="Escudo UNSM" class="footer-logo" width="60">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autónomo y de carácter estatal, comprometido con la formación de profesionales humanistas y competitivos.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martín - Perú</p>
                    <p>Central Telefónica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rápidos</h3>
                <ul class="footer-links">
                    <li><a href="../../../../#admision">Admisión</a></li>
                    <li><a href="../../../../#facultades">Facultades</a></li>
                    <li><a href="../../../../#posgrado">Posgrado</a></li>
                    <li><a href="../../../../#investigacion">Investigación</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="#">Biblioteca Virtual</a></li>
                    <li><a href="#">Campus Virtual</a></li>
                    <li><a href="#">Repositorio Institucional</a></li>
                    <li><a href="#">Portal de Transparencia</a></li>
                    <li><a href="#">Libro de Reclamaciones</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <?php include '../plugin/meta.html'; ?>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martín. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Síguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer"><img src="../../../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22"></a>
                        <a href="https://www.instagram.com/unsmperu" target="_blank" rel="noopener noreferrer"><img src="../../../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22"></a>
                        <a href="https://youtube.com/@unsmperu" target="_blank" rel="noopener noreferrer"><img src="../../../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22"></a>
                        <a href="https://www.tiktok.com/@campus.unsm" target="_blank" rel="noopener noreferrer"><img src="../../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22"></a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer"><img src="../../../../imagenes/redes/logo x.png" alt="X" width="22" height="22"></a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="../../../../js/script.js"></script>
    <script src="js/scriptGesAmb.js"></script>
    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>
</body>
</html>
